#ifndef DATASIMSTATE_H_
#define DATASIMSTATE_H_

#include "Vector3f.h"

namespace DataTypes
{

class DataSimState
{
public:
	DataSimState();
	DataSimState(bool initialized,
	bool syncmode,
	bool flagsync,
	bool stepmode,
	bool stepflag,
	bool broadcastflag,
	float stepsize,
	double lastTime,
	double lastSync,
	double syncwait,
	int itercount,
	Vector3f worldgravity,
	float worldhardness,
	float worldbounciness, 
	int stepsperiteration,
	bool fastmode,
	bool autoadjustmode,
	float lastaverageelapsedstep,
	int lastaveragestepsperiteration);
	
	
	
	virtual ~DataSimState();
	bool GetInitialized();
	bool GetSyncMode();
	bool GetFlagSync();
	bool GetStepMode();
	bool GetStepflag();
	bool GetBroadcastflag();
	float GetStepSize();
	double GetLastTime();
	double GetLastSync();
	double GetSyncWait();
	int GetIterCount();
	Vector3f GetWorldGravity();
	float GetWorldHardness();
	float GetWorldBounciness();
	int GetStepsPerIteration();
	bool GetFastMode();
	bool GetAutoAdjustMode();
	float GetLastAverageElapsedStep();
	int GetLastAverageStepsPerIteration();
	string ToString();
private:
	bool initialized;
	bool syncmode;
	bool flagsync;
	bool stepmode;
	bool stepflag;
	bool broadcastflag;
	float stepsize;
	double lastTime;
	double lastSync;
	double syncwait;
	int itercount;
	Vector3f worldgravity;
	float worldhardness;
	float worldbounciness;
	int stepsperiteration;
	bool fastmode;
	bool autoadjustmode;
	float lastaverageelapsedstep;
	int lastaveragestepsperiteration;
};

}

#endif /*DATASIMSTATE_H_*/
